#pragma once

#include <util/stream/format.h>
#include <util/stream/output.h>

namespace NPassport::NBb {
    template <typename T>
    struct TInvalidValueProxy {
        const T& Value;
        const size_t MaxLen = 256;

        operator TString() const {
            TStringStream s;
            s << (*this);
            return s.Str();
        }
    };

    template <typename T>
    TInvalidValueProxy<T> InvalidValue(const T& value, size_t maxLen = 256) {
        return TInvalidValueProxy<T>{
            .Value = value,
            .MaxLen = maxLen,
        };
    };
}

template <typename T>
IOutputStream& operator<<(IOutputStream& o, const NPassport::NBb::TInvalidValueProxy<T>& value) {
    static_assert(std::is_integral_v<T>, "Only integer types and strings are supported");
    o << "'" << value.Value << "'";
    return o;
}

template <>
IOutputStream& operator<<(IOutputStream& o, const NPassport::NBb::TInvalidValueProxy<TStringBuf>& value);

template <>
IOutputStream& operator<<(IOutputStream& o, const NPassport::NBb::TInvalidValueProxy<TString>& value);
