#include "lrandoms_dumper.h"

#include <passport/infra/libs/cpp/auth_core/keyring.h>
#include <passport/infra/libs/cpp/auth_core/sessionsigner.h>

#include <util/stream/file.h>
#include <util/system/error.h>
#include <util/system/fs.h>
#include <util/system/sysstat.h>

namespace NPassport::NBb {
    TLRandomsDumper::TLRandomsDumper(const TString& filename,
                                     const NAuth::TSessionSigner& signer,
                                     const TString& keyspace)
        : Filename_(filename)
        , Signer_(signer)
        , Keyspace_(keyspace)
    {
        Run();
    }

    void TLRandomsDumper::Run() {
        NAuth::TKeyRing* ring = Signer_.GetRingByName(Keyspace_);
        Y_ENSURE(ring, "Missing keyring '" << Keyspace_ << "' for " << Filename_);
        TLog::Debug() << "LRandomsDumper: start dumping";

        const TInstant start = TInstant::Now();
        TString tmpfilename = Filename_ + ".tmp";
        {
            TFileOutput out(tmpfilename);
            ring->PrintAsTxt(out);
        }
        TLog::Debug() << "LRandomsDumper: file is ready: " << tmpfilename
                      << ". Trying to rename it";

        Chmod(tmpfilename.c_str(),
              // 400 | 040 | 004
              S_IRUSR | S_IRGRP | S_IROTH);

        Y_ENSURE(NFs::Rename(tmpfilename, Filename_),
                 "Failed to rename '" << tmpfilename << "' to '" << Filename_ << "'. "
                                      << LastSystemErrorText());
        TLog::Debug() << "LRandomsDumper: finished with file " << Filename_
                      << " took " << (TInstant::Now() - start);
    }
}
