#include "lrcs_cookie_parser.h"

namespace NPassport::NBb {

    bool TLrcsCookieParser::IsLrcsNotTooOld(const TString& lrcsStr, const time_t lrcsTtl, TInstant now) {
        time_t ts = 0;
        const time_t lrcs = TryIntFromString<10>(lrcsStr, ts) ? ts : 0;
        return now.TimeT() < lrcs + lrcsTtl;
    }
}
