#pragma once

#include <util/generic/hash.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NBb {
    class TPartitionsSettings {
    public:
        using TPartitionIdByName = THashMap<TString, ui64>;
        using TPartitionNameById = THashMap<ui64, TString>;

        TPartitionsSettings(TPartitionIdByName&& partitions, const TString& defaultPartition);

        // shortcuts
        bool IsDefaultPartition(ui64 id) const;
        bool IsDefaultPartition(TStringBuf partition) const;

        ui64 GetDefaultPartitionId() const;
        ui64 GetPartitionId(TStringBuf partition) const;

        const TString& GetPartitionName(ui64 id) const;

    private:
        const TPartitionIdByName PartitionsByName_;
        const TPartitionNameById PartitionsById_;
        const ui64 DefaultPartition_;
    };
}
