#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    class TPassportWrapper {
    public:
        TPassportWrapper(std::shared_ptr<NDbPool::TDbPool> db, const TString& consumer);
        ~TPassportWrapper();

        bool UpdateTotpCheckTime(const TString& uid, time_t checkTime);

    private:
        const TString TotpCheckTimePath_;

        std::shared_ptr<NDbPool::TDbPool> PassportDb_;
    };

}
