#pragma once

#include <passport/infra/libs/cpp/auth_core/keymap.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NArgon {
    class TArgon2Factory;
}

namespace NPassport::NBb {
    class TPasswordChecker {
    public:
        TPasswordChecker();
        TPasswordChecker(NAuth::TKeyMap&& secrets,
                         ui32 hashlen,
                         ui32 tCost,  // number of passes
                         ui32 mCost); // amount of memory requested (KB)
        ~TPasswordChecker();

        bool PasswordMatches(const TString& pwd, const TString& hash, const TString& uid, bool supportOldHashes = false) const;

        TString MakeHash(const TString& pwd, const TString& uid, int ver) const;

        // This is used from python in passport/infra/tools/argonizer
        TString ConvertMD5ToArgon(const TString& md5hash, const TString& uid) const;
        TString ConvertRawMD5ToArgon(const TString& md5hash, const TString& uid) const;

    private:
        static TString Md5crypt(const TString& pwd, const char* salt = nullptr);
        static TString Md5Raw(const TString& pwd);
        TString ArgonWithMd5Crypt(const TString& md5hash, const TString& uid) const;
        TString ArgonRaw(const TString& value, const TString& uid) const;

        static bool CheckMD5Hash(const TString& pwd, const char* hash);
        bool CheckArgonWithMD5Hash(const TString& pwd, TStringBuf attrView, const TString& uid) const;
        bool CheckArgonWithRawMD5Hash(const TString& pwd, TStringBuf attrView, const TString& uid) const;

        static bool Matches(const char* crypted, const char* hash);

        const ui32 TCost_ = 0;
        const ui32 MCost_ = 0;
        const NAuth::TKeyMap Secrets_ = {};
        const std::unique_ptr<NArgon::TArgon2Factory> Argon2_;
    };

}
