#pragma once

#include <util/generic/string.h>

#include <memory>
#include <optional>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    enum class ENetworkKind;

    class TPerimeterWrapper {
    public:
        TPerimeterWrapper(std::shared_ptr<NDbPool::TDbPool> db);
        ~TPerimeterWrapper();

        /// Status of Login operation
        enum EStatus {
            LoginOk,
            Rejected,
            Error,
            SecondStep,
        };

        EStatus Login(const TString& login,
                      const TString& password,
                      const TString& ipaddr,
                      const TString& authType,
                      ENetworkKind ipKind,
                      bool isRobot,
                      TString& reqId,
                      TString& msg,
                      std::optional<TString>& allowedSecondSteps,
                      bool& passwordChangeRequired) const;

        bool DbOk(TString& msg) const;

    protected:
        static EStatus ParseResponse(const TString& body,
                                     TString& reqId,
                                     TString& msg,
                                     std::optional<TString>& allowedSecondSteps,
                                     bool& passwordChangeRequired);

    private:
        const TString Path_;
        std::shared_ptr<NDbPool::TDbPool> PerimeterDb_;
    };

}
