#pragma once

#include <util/generic/string.h>

#include <array>

namespace NPassport::NDbPool {
    class TDbPool;
    class TQuery;
}

namespace NPassport::NBb {
    class TBlackboxImpl;

    struct TRateLimiterSettings {
        enum ELimit {
            GetDebugUserTicket,

            COUNT,
        };

        ui64 Period = 0;
        TString Keyspace;

        std::array<ui64, ELimit::COUNT> Limits;
    };

    class IRateLimiter {
    public:
        virtual ~IRateLimiter() = default;

        virtual bool CheckLimit(const TString& key,
                                TRateLimiterSettings::ELimit limit) const = 0;
    };

    class TKolmogorBasedRateLimiter: public IRateLimiter {
    public:
        TKolmogorBasedRateLimiter(NDbPool::TDbPool& kolmogor,
                                  const TRateLimiterSettings& settings);

        bool CheckLimit(const TString& key,
                        TRateLimiterSettings::ELimit limit) const override;

    public:
        static NDbPool::TQuery BuildQuery(const TRateLimiterSettings& settings,
                                          const TString& key,
                                          ui64 limit);
        static bool ParseResponse(const TStringBuf response,
                                  const TString& keyspace,
                                  const TString& key);

    private:
        NDbPool::TDbPool& Kolmogor_;
        const TRateLimiterSettings Settings_;
    };

    class TNoopRateLimiter: public IRateLimiter {
    public:
        bool CheckLimit(const TString& key,
                        TRateLimiterSettings::ELimit limit) const override;
    };
}
