#include "response_cache.h"

#include <set>

namespace NPassport::NBb {
    static const TString AUTHORIZATION("Authorization");

    const TResponseCache::TKey& TResponseCache::TCacheHolder::BuildKey(const NCommon::TRequest& request, TStringBuf consumer) {
        if (!IsEnabled()) {
            return Key_;
        }

        std::set<TStringBuf> params;
        size_t paramsLength = 0;

        auto fetchFrom = [&params, &paramsLength](TStringBuf str) {
            while (str) {
                TStringBuf buf = str.NextTok('&');
                params.insert(buf);
                paramsLength += buf.size() + 1;
            }
        };
        fetchFrom(request.GetRequestCgi());
        fetchFrom(request.GetRequestBody());

        TStringBuf type = request.GetConsumerFormattedName().StartsWith("1:") ? "ip" : "tvm";
        TStringBuf oauthToken = request.GetHeader(AUTHORIZATION);

        Key_ = NUtils::CreateStrExt(paramsLength, type, "|", consumer, "|", oauthToken, "|");
        for (TStringBuf s : params) {
            Key_.append(s.data(), s.size()).push_back('&');
        }

        return Key_;
    }

    TResponseCache::TValue TResponseCache::TCacheHolder::GetValue(NCache::EStatus& status) const {
        return TBase::GetValue(Key_, status);
    }

    void TResponseCache::TCacheHolder::PutValue(TValue data) {
        TBase::PutValue(std::move(Key_), std::move(data));
    }
}
