#pragma once

#include <passport/infra/libs/cpp/cache/cache.h>
#include <passport/infra/libs/cpp/cache/cache_holder.h>
#include <passport/infra/libs/cpp/request/request.h>

namespace NPassport::NBb {
    class TResponseCache {
    public:
        using TKey = TString;
        using TValue = std::shared_ptr<const TString>;

        using TCache = NCache::TCachePtr<TKey, TValue>;
        using TContext = NCache::TContext<TKey, TValue>;
        using TContextPtr = NCache::TContextPtr<TKey, TValue>;

        TResponseCache(TCache json,
                       TCache xml,
                       TDuration lifeTime,
                       bool isDryRun)
            : Json(std::move(json))
            , Xml(std::move(xml))
            , DefaultLifeTime(lifeTime)
            , IsDryRun(isDryRun)
        {
        }

        class TCacheHolder: public NCache::TCacheHolder<TKey, TValue> {
            using TBase = NCache::TCacheHolder<TKey, TValue>;

        public:
            TCacheHolder() = default;

            TCacheHolder(TCacheHolder&&) = default;
            TCacheHolder& operator=(TCacheHolder&&) = default;

            using TBase::TBase;

            const TKey& BuildKey(const NCommon::TRequest& request, TStringBuf consumer);

            TValue GetValue(NCache::EStatus& status) const;
            void PutValue(TValue data);

        private:
            TString Key_;
        };

        TCacheHolder GetCache(bool isJson, TDuration lifeTime) const {
            return TCacheHolder(isJson ? Json : Xml, lifeTime, IsDryRun);
        }

        TCache Json;
        TCache Xml;

        const TDuration DefaultLifeTime;
        const bool IsDryRun;
    };
}
