#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

#include <map>
#include <memory>
#include <time.h>
#include <vector>

namespace NPassport::NDbPool {
    class TDbPool;
    class TNonBlockingHandle;
}

namespace NPassport::NBb {
    class TTskvLog;

    class TSessKillWrapper {
    public:
        TSessKillWrapper(const TTskvLog* tskv,
                         std::shared_ptr<NDbPool::TDbPool> db);
        ~TSessKillWrapper();

        using TUidsList = std::vector<TString>;
        using TUidLoginDeltaMap = std::map<TString, time_t>;

        NDbPool::TNonBlockingHandle SendRequest(const TUidsList& uids, const TString& authid);
        bool IsKilled(NDbPool::TNonBlockingHandle sqlh, const TUidLoginDeltaMap& deltas, const TString& authid, time_t authidTime);

    private:
        const TTskvLog* TskvLogger_;

        const TString Path_;

        std::shared_ptr<NDbPool::TDbPool> SessKillDb_;
    };

}
