#include "sessguard_options.h"

namespace NPassport::NBb {
    TSessGuardOptions::TSessGuardOptions(size_t enableRate, size_t needResetRate)
        : EnableRate_(enableRate)
        , NeedResetRate_(needResetRate)
    {
    }

    static size_t GetRate(const TString& str) {
        return std::hash<TString>{}(str) % 100;
    }

    bool TSessGuardOptions::IsEnabled(const TString& userip) const {
        return GetRate(userip) < EnableRate_;
    }

    bool TSessGuardOptions::IsNeedResetStatus(const TString& userip) const {
        return GetRate(userip) < NeedResetRate_;
    }
}
