#pragma once

#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/system/types.h>

#include <map>
#include <memory>
#include <vector>

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NBb {
    // Keep mapping of uid ranges to shards
    // NB: shard_t is 0-based, relating shard # n+1
    class TShardRanges {
    public:
        using TUid = ui64;
        using TShard = ui32;

        TShardRanges();
        void Init(IInputStream& config, TShard shardCount);
        TShard GetShard(const TString& uid) const;

    private:
        std::map<TUid, TShard> Ranges_;
    };

    class TShardsMap {
    public:
        TShardsMap();
        virtual ~TShardsMap();

        void Init(const TString& prefix,
                  const TString& dbPrefix,
                  const NXml::TConfig& config,
                  std::shared_ptr<NPassport::NDbPool::TDbPoolCtx> ctx);

        unsigned GetShardCount() const;
        NDbPool::TDbPool& GetPool(ui32 s) const;
        NDbPool::TDbPool* GetPoolUnsafe(ui32 s) const;

        using TShards = std::vector<std::reference_wrapper<NDbPool::TDbPool>>;
        const TShards& GetShards() const {
            return Out_;
        }

        bool ShardsOk(TString& statusbuf) const;

    protected:
        std::vector<std::shared_ptr<NDbPool::TDbPool>> Shards_;
        TShards Out_;
    };

    class TRangedShardsMap: public TShardsMap {
    public:
        TRangedShardsMap();
        ~TRangedShardsMap() override;

        void Init(const TString& prefix,
                  const NXml::TConfig& config,
                  std::shared_ptr<NPassport::NDbPool::TDbPoolCtx> ctx);

        using TShardsMap::GetPool;
        NDbPool::TDbPool& GetPool(const TString& uid) const;
        std::vector<TString> SplitUids(const std::vector<TString>& uidsList) const;

    private:
        TShardRanges Ranges_;
    };

}
