#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <time.h>
#include <unordered_set>

namespace NPassport::NAuth {
    class TKeyRing;
    class TSessionSigner;
}

namespace NPassport::NBb {
    class TSigner {
    public:
        enum class EStatus {
            Ok,
            Expired,
            NoKey,
            Invalid
        };

        TSigner(const NAuth::TSessionSigner& sessSigner,
                std::unordered_set<TString>&& longSignSpaces);
        ~TSigner() = default;

        static const TString& StatusStr(EStatus status);
        NAuth::TKeyRing* GetRing(const TString& signSpace) const;

        TString Sign(const TString& value, const TString& signSpace, const TString& ttl, time_t now = time(nullptr)) const;

        struct TCheckResult {
            explicit TCheckResult(EStatus status,
                                  TStringBuf keyId,
                                  time_t expires = 0,
                                  TString&& value = {})
                : Status(status)
                , KeyId(keyId)
                , Expires(expires)
                , Value(std::move(value))
            {
            }

            const EStatus Status;
            const TStringBuf KeyId;
            const time_t Expires;
            const TString Value;

            bool operator==(const TCheckResult& o) const { // for tests
                return Status == o.Status &&
                       KeyId == o.KeyId &&
                       Expires == o.Expires &&
                       Value == o.Value;
            }
        };
        TCheckResult CheckSign(const TString& signedValue, const TString& signSpace, time_t now = time(nullptr)) const;

    private:
        const std::unordered_set<TString> LongSignSpaces_;
        NAuth::TKeyRing* Keyring_;
        NAuth::TKeyRing* KeyringLong_;
    };

}
