#pragma once

#include "strings.h"

#include <passport/infra/libs/cpp/utils/shared_state.h>
#include <passport/infra/libs/cpp/utils/log/global.h>

#include <util/generic/string.h>

#include <memory>
#include <regex>
#include <set>

namespace NPassport::NDbPool {
    class TDbPool;
}

namespace NPassport::NBb {
    class TStopWordsList {
    public:
        TStopWordsList(NDbPool::TDbPool& db, const TString& defaultStopWords = TStrings::EMPTY);
        virtual ~TStopWordsList();

        bool IsStopWord(const TString& word) const;
        bool IsStopSubstr(const TString& substr) const;

    protected:
        void Run();

    private:
        std::shared_ptr<std::set<TString>> LoadWords();
        std::shared_ptr<std::regex> LoadSubwords();

        // predefined stop words list
        std::set<TString> DefaultStopWords_;
        // set of stop words
        NUtils::TSharedState<std::set<TString>> StopWords_;
        // regexp of stop subwords
        NUtils::TSharedState<std::regex> StopSubwords_;
        unsigned SubwordsCount_ = 0U;

        NDbPool::TDbPool& Db_;
    };
}
