#include "strings.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NBb {
    const TString TStrings::EMPTY;

    const TString TStrings::MINUS_ONE = "-1";
    const TString TStrings::ZERO = "0";
    const TString TStrings::ONE = "1";
    const TString TStrings::TWO = "2";
    const TString TStrings::THREE = "3";
    const TString TStrings::FOUR = "4";

    const TString TStrings::ADD = "add";
    const TString TStrings::ADD_SCOPE_SESSIONID = "add_scope_sessionid";
    const TString TStrings::ADD_SCOPE_SESSGUARD = "add_scope_sessguard";
    const TString TStrings::ALL = "all";
    const TString TStrings::ALL_WITH_HIDDEN = "all_with_hidden";
    const TString TStrings::ALLOW_SCHOLAR = "allow_scholar";
    const TString TStrings::ALLOW_FEDERAL = "allow_federal";
    const TString TStrings::ALIASES = "aliases";
    const TString TStrings::API_VERSION = "ver";
    const TString TStrings::APP_PASSWORD_PREFIX = "app_password:";
    const TString TStrings::ATTRIBUTES = "attributes";
    const TString TStrings::AUTHID = "authid";
    const TString TStrings::AUTH_TIME = "auth_time";
    const TString TStrings::BOUND = "bound";
    const TString TStrings::BOUND_AFTER = "bound_after";
    const TString TStrings::CHUNK_COUNT = "chunk_count";
    const TString TStrings::CHUNK_NO = "chunk_no";
    const TString TStrings::CLIENT_ID = "client_id";
    const TString TStrings::COUNTRY = "country";
    const TString TStrings::CREATE = "create";
    const TString TStrings::CREATE_TIME = "create_time";
    const TString TStrings::CREDENTIAL_ID = "credential_id";
    const TString TStrings::CURRENT = "current";
    const TString TStrings::DBFIELDS = "dbfields";
    const TString TStrings::DEFAULT_SCOPE_KEYWORD = "login:email";
    const TString TStrings::DEFAULT_UID = "default_uid";
    const TString TStrings::DELETE = "delete";
    const TString TStrings::DELETED_AFTER = "deleted_after";
    const TString TStrings::DELETED_BEFORE = "deleted_before";
    const TString TStrings::DELETED_SCOPES_PREFIX = "deleted:";
    const TString TStrings::DEPTH = "depth";
    const TString TStrings::DEVICE_ID = "device_id";
    const TString TStrings::DOMAIN_ADMIN = "domain_admin";
    const TString TStrings::DOMAIN_ = "domain";
    const TString TStrings::DOMAIN_ID = "domain_id";
    const TString TStrings::EMAIL = "email";
    const TString TStrings::EMAIL_ATTRIBUTES = "email_attributes";
    const TString TStrings::EMAILS = "emails";
    const TString TStrings::EXPIRE_TIME = "expire_time";
    const TString TStrings::FAMILY_ID = "family_id";
    const TString TStrings::FIND_BY_PHONE_ALIAS = "find_by_phone_alias";
    const TString TStrings::FINISHED_BEFORE = "finished_before";
    const TString TStrings::FORCE_OFF = "force_off";
    const TString TStrings::FORCE_ON = "force_on";
    const TString TStrings::FORCE_RESIGN = "force_resign";
    const TString TStrings::FORCE_SHOW_MAIL_SUBSCRIPTION = "force_show_mail_subscription";
    const TString TStrings::FULL_INFO = "full_info";
    const TString TStrings::GET_ALL = "getall";
    const TString TStrings::GET_ALLOW_MORE_KIDS = "get_allow_more_kids";
    const TString TStrings::GET_BADAUTH_COUNTS = "get_badauth_counts";
    const TString TStrings::GET_BILLING_FEATURES = "get_billing_features";
    const TString TStrings::GET_EMAILS = "getemails";
    const TString TStrings::GET_FAMILY_INFO = "get_family_info";
    const TString TStrings::GET_IS_XTOKEN_TRUSTED = "get_is_xtoken_trusted";
    const TString TStrings::GET_LOGIN_ID = "get_login_id";
    const TString TStrings::GET_MEMBERS_INFO = "get_members_info";
    const TString TStrings::GET_PLACE = "get_place";
    const TString TStrings::GET_PLUS_SUBSCRIBER_STATE = "get_plus_subscriber_state";
    const TString TStrings::GET_PHONEBINDINGS = "getphonebindings";
    const TString TStrings::GET_PHONENUMBER = "getphonenumber";
    const TString TStrings::GET_PHONEOPERATIONS = "getphoneoperations";
    const TString TStrings::GET_PHONES = "getphones";
    const TString TStrings::GET_PUBLIC_ID = "get_public_id";
    const TString TStrings::GET_PUBLIC_NAME = "get_public_name";
    const TString TStrings::GET_SOCIAL = "getsocial";
    const TString TStrings::GET_USER_TICKET = "get_user_ticket";
    const TString TStrings::GET_USER_TICKET_FOR_KID = "get_user_ticket_for_kid";
    const TString TStrings::GET_WEBAUTHN_CREDENTIALS = "get_webauthn_credentials";
    const TString TStrings::GET_REG_COMPLETION_RECOMMENDATION_WITH_YP = "get_reg_completion_recommendation_with_yp";
    const TString TStrings::GUARD_HOSTS = "guard_hosts";
    const TString TStrings::HASHES = "hashes";
    const TString TStrings::HAVE_PASSWORD = "have_password";
    const TString TStrings::HISTORY = "history";
    const TString TStrings::HOST = "host";
    const TString TStrings::HOST_ID = "host_id";
    const TString TStrings::STATBOX_ID = "statbox_id";
    const TString TStrings::IGNORE_COUNT = "ignore_count";
    const TString TStrings::IGNORE_STOPLIST = "ignore_stoplist";
    const TString TStrings::IGNOREBINDLIMIT = "ignorebindlimit";
    const TString TStrings::IP = "ip";
    const TString TStrings::IS_BETATESTER = "is_betatester";
    const TString TStrings::IS_DISPLAY_NAME_EMPTY = "is_display_name_empty";
    const TString TStrings::IS_LITE = "is_lite";
    const TString TStrings::IS_PDD = "is_pdd";
    const TString TStrings::IS_SCHOLAR = "is_scholar";
    const TString TStrings::IS_STRESS = "is_stress";
    const TString TStrings::IS_YASTAFF = "is_yastaff";
    const TString TStrings::JUST_DEFAULT = "getdefault";
    const TString TStrings::JUST_YANDEX = "getyandex";
    const TString TStrings::KEY_ID = "key_id";
    const TString TStrings::KEYSPACE = "keyspace";
    const TString TStrings::LANG = "lang";
    const TString TStrings::LANG_RU = "ru";
    const TString TStrings::LIMIT = "limit";
    const TString TStrings::L = "l";
    const TString TStrings::LOGIN = "login";
    const TString TStrings::LOGIN_ID = "login_id";
    const TString TStrings::LOGINS = "logins";
    const TString TStrings::LRCS_COOKIE_NAME = "lrcs";
    const TString TStrings::MAX_AGE = "max_age";
    const TString TStrings::MD5CRYPT = "md5crypt";
    const TString TStrings::META = "meta";
    const TString TStrings::METHOD = "method";
    const TString TStrings::MULTI = "multi";
    const TString TStrings::MULTISESSION = "multisession";
    const TString TStrings::NETS = "nets";
    const TString TStrings::NEWDEFAULT = "new_default";
    const TString TStrings::NO = "no";
    const TString TStrings::NONCE = "nonce";
    const TString TStrings::NONCE_SIGN_SPACE = "nonce_sign_space";
    const TString TStrings::NUMBER = "number";
    const TString TStrings::NUMBERS = "numbers";
    const TString TStrings::OAUTH_CLIENT_ATTRIBUTES = "oauth_client_attributes";
    const TString TStrings::OAUTH_TOKEN = "oauth_token";
    const TString TStrings::OAUTH_TOKEN_ATTRIBUTES = "oauth_token_attributes";
    const TString TStrings::OAUTHCHECK = "oauthcheck";
    const TString TStrings::OFF = "off";
    const TString TStrings::OFFSET = "offset";
    const TString TStrings::OK = "OK";
    const TString TStrings::OLD_SECRET_ID = "old_secret_id";
    const TString TStrings::OP = "op";
    const TString TStrings::PARTITION = "partition";
    const TString TStrings::PASSWORD = "password";
    const TString TStrings::PASSWORD_CHECK_TIME = "password_check_time";
    const TString TStrings::PAYMENT_AUTH_CONTEXT_ID = "payment_auth_context_id";
    const TString TStrings::PAYMENT_AUTH_SCOPE_ADDENDUM = "payment_auth_scope_addendum";
    const TString TStrings::PHONE_ATTRIBUTES = "phone_attributes";
    const TString TStrings::PHONE_IDS = "phone_ids";
    const TString TStrings::PHONE_NUMBER = "phone_number";
    const TString TStrings::PIN = "pin";
    const TString TStrings::PINTOTEST = "pintotest";
    const TString TStrings::PIN_SECRET_ID = "pin_secret_id";
    const TString TStrings::PIN_SECRET_SALT = "pin_secret_salt";
    const TString TStrings::PUBLIC_ID = "public_id";
    const TString TStrings::PUBLIC_KEY = "public_key";
    const TString TStrings::RAWMD5 = "rawmd5";
    const TString TStrings::REASON = "reason";
    const TString TStrings::REGNAME = "regname";
    const TString TStrings::REPLACE = "replace";
    const TString TStrings::REQUEST_ID = "request_id";
    const TString TStrings::RESIGN = "resign";
    const TString TStrings::RESIGN_FOR_DOMAINS = "resign_for_domains";
    const TString TStrings::SCOPES = "scopes";
    const TString TStrings::SECRET_ID = "secret_id";
    const TString TStrings::SECRET_SALT = "secret_salt";
    const TString TStrings::SELECT = "select";
    const TString TStrings::SESSGUARD = "sessguard";
    const TString TStrings::SESSION_ID = "sessionid";
    const TString TStrings::SID = "sid";
    const TString TStrings::SIGN_SPACE = "sign_space";
    const TString TStrings::SIGNATURE = "signature";
    const TString TStrings::SIGNED_VALUE = "signed_value";
    const TString TStrings::SKEW = "skew";
    const TString TStrings::SOCIAL_ID = "social_id";
    const TString TStrings::SORT = "sort";
    const TString TStrings::SUIDS = "suids";
    const TString TStrings::SUID = "suid";
    const TString TStrings::TESTED_EMAIL = "addrtotest";
    const TString TStrings::TEST_ONE = "testone";
    const TString TStrings::TIMESTAMP = "timestamp";
    const TString TStrings::TOKEN_ID = "token_id";
    const TString TStrings::TOTP = "totp";
    const TString TStrings::TOTP_ID = "totp_id";
    const TString TStrings::TOTP_SALT = "totp_salt";
    const TString TStrings::TOTP_SECRET_ARG_NAME = "secret";
    const TString TStrings::TRACK_ID = "track_id";
    const TString TStrings::TS = "ts";
    const TString TStrings::TTL = "ttl";
    const TString TStrings::TYPE = "type";
    const TString TStrings::UID = "uid";
    const TString TStrings::UNBOUND = "unbound";
    const TString TStrings::UNKNOWN = "UNKNOWN";
    const TString TStrings::USE_JUNK_SECRET = "use_junk_secret";
    const TString TStrings::USERAGENT = "useragent";
    const TString TStrings::USER_IP = "userip";
    const TString TStrings::USER_PORT = "user_port";
    const TString TStrings::USER_TICKET = "user_ticket";
    const TString TStrings::VALUE = "value";
    const TString TStrings::VERSION = "version";
    const TString TStrings::WEBAUTHN_CREDENTIAL_ATTRIBUTES = "webauthn_credential_attributes";
    const TString TStrings::XTOKEN_ID = "xtoken_id";
    const TString TStrings::XTOKEN_ONLY = "xtoken_only";
    const TString TStrings::XTOKEN_SHARD = "xtoken_shard";
    const TString TStrings::X_YA_SERVICE_TICKET = "X-Ya-Service-Ticket";
    const TString TStrings::YANDEXUID = "yandexuid";
    const TString TStrings::YANDEXUSERS = "yandexusers";
    const TString TStrings::YATEAM_AUTH = "yateam_auth";

    const TString TStrings::ALTDOMAIN_SID = "61";
    const TString TStrings::BANK_SID = "bank";
    const TString TStrings::MAIL_NAROD_SID = "16";
    const TString TStrings::MAIL_SID = "2";
    const TString TStrings::MAILISH_SID = "mailish";
    const TString TStrings::MK_SID = "33";
    const TString TStrings::NEOPHONISH_SID = "120";
    const TString TStrings::PASSPORT_SID = "8";
    const TString TStrings::FEDERAL_SID = "federal";
    const TString TStrings::SID_58 = "58";
    const TString TStrings::SID_65 = "65";
    const TString TStrings::SID_68 = "68";
    const TString TStrings::UBER_SID = "uber";

    const TString TStrings::KOLONKISH_LOGIN_PREFIX = "kolonkish-";
    const TString TStrings::NEOPHONISH_LOGIN_PREFIX = "nphne-";
    const TString TStrings::PHONISH_LOGIN_PREFIX = "phne-";
    const TString TStrings::SOCIAL_LOGIN_PREFIX = "uid-";
    const TString TStrings::YAMBOT_LOGIN_PREFIX = "yambot-";

    static const TString PHONE_OPERATIONS_VALUE =
        "CONCAT_WS(',',id,uid,"
        "phone_id,security_identity,type,UNIX_TIMESTAMP(started),"
        "UNIX_TIMESTAMP(finished),code_value,code_checks_count,code_send_count,"
        "UNIX_TIMESTAMP(code_last_sent),UNIX_TIMESTAMP(code_confirmed),"
        "UNIX_TIMESTAMP(password_verified),flags,phone_id2) AS value";

    static const TString PHONE_OPERATIONS_METHOD_START = "SELECT ";
    static const TString PHONE_OPERATIONS_METHOD_END =
        " FROM phone_operations where finished<from_unixtime(";

    void TQueries::AppendPhoneOperationsMethod(TString& buf, const TString& timestamp) {
        NUtils::Append(buf,
                       PHONE_OPERATIONS_METHOD_START,
                       PHONE_OPERATIONS_VALUE,
                       PHONE_OPERATIONS_METHOD_END,
                       timestamp,
                       ")");
    }

    static const TString PHONE_OPERATIONS_FIELD_START =
        "(SELECT uid,0 AS type,";
    static const TString PHONE_OPERATIONS_FIELD_END =
        ",101 AS entity_type,id AS entity_id FROM phone_operations WHERE uid IN (";

    void TQueries::AppendPhoneOperationsField(TString& buf, const TString& uids) {
        NUtils::Append(buf,
                       PHONE_OPERATIONS_FIELD_START,
                       PHONE_OPERATIONS_VALUE,
                       PHONE_OPERATIONS_FIELD_END,
                       uids,
                       "))");
    }

}
