#pragma once

#include "db_profile.h"
#include "db_types.h"

#include <util/generic/string.h>

#include <functional>
#include <unordered_map>

namespace NPassport::NBb {
    class TDbFetcher;
    class TTotpEncryptor;

    class TSyntheticAttributes {
    public:
        using TProxyAttrsMap = std::unordered_map<TString, TString>;

        TSyntheticAttributes(time_t fullFioStartTime, TProxyAttrsMap&& proxyAttributes);

        // function for obtaining value of synthetic attributes
        using TAttrFuncType = std::function<TString(const TDbProfile*)>;

        // function for obtaining value of synthetic extended attributes
        using TExtAttrFuncType = std::function<TString(const TDbProfile*, const TString&)>;
        // map: synthetic extended attribute -> synthesis function
        using TSyntheticExtEntity = std::unordered_map<TString, TExtAttrFuncType>;

        TAttrFuncType GetSyntheticFunc(TDbFetcher& fetcher, const TString& attr) const;
        TExtAttrFuncType GetSyntheticExtPhoneFunc(TDbFetcher& fetcher, const TString& attr) const;
        TExtAttrFuncType GetSyntheticExtEmailFunc(TDbFetcher& fetcher, const TString& attr) const;
        TExtAttrFuncType GetSyntheticExtWebauthnFunc(TDbFetcher& fetcher, const TString& attr) const;

        using TAttrFuncs = std::unordered_map<
            TString,
            std::function<TAttrFuncType(TDbFetcher&, const TSyntheticAttributes*)>>;
        using TExtAttrFuncs = std::unordered_map<
            TString,
            std::function<TExtAttrFuncType(TDbFetcher&, const TSyntheticAttributes*)>>;

    private:
        static TAttrFuncType ProxyAttrFunc(TDbFetcher& fetcher, const TString& attr);

        static const TAttrFuncs& AttrFuncs();
        static const TExtAttrFuncs& PhoneAttrFuncs();
        static const TExtAttrFuncs& EmailAttrFuncs();
        static const TExtAttrFuncs& WebauthnAttrFuncs();

        static TString AttrBirthDayFunc(const TDbProfile* profile, TDbIndex birthdate);
        static TString AttrBirthYearFunc(const TDbProfile* profile, TDbIndex birthdate);
        static TString Attr2FaOnFunc(const TDbProfile* profile, TDbIndex secret);
        static TString Attr2FaPinFunc(const TDbProfile* profile, TDbIndex secret, const TTotpEncryptor* totpEncryptor);
        static TString AttrHavePasswordFunc(const TDbProfile* profile, TDbIndex passwd, TDbIndex secret);
        static TString AttrHaveHintFunc(const TDbProfile* profile, TDbIndex hintq, TDbIndex hinta);
        static TString AttrFioFunc(const TDbProfile* profile, TDbIndex firstname, TDbIndex lastname);
        static TString AttrNormalizedLogin(const TDbProfile* profile,
                                           TDbIndex pdd,
                                           TDbIndex portal,
                                           TDbIndex alt,
                                           TDbIndex social,
                                           TDbIndex lite,
                                           TDbIndex phne,
                                           TDbIndex mailish,
                                           TDbIndex uber,
                                           TDbIndex yambot,
                                           TDbIndex colonkish,
                                           TDbIndex kpId,
                                           TDbIndex neophonish,
                                           TDbIndex scholar);
        static TString AttrIsAvailable(const TDbProfile* profile, TDbIndex disabled);
        static TString AttrSecretIds(const TDbProfile* profile, TDbIndex totpSecrets, const TTotpEncryptor* totpEncryptor);
        static TString AttrHaveOrganizationName(const TDbProfile* profile);
        static TString Attr2FaPinLength(const TDbProfile* profile,
                                        TDbIndex secret,
                                        const TTotpEncryptor* totpEncryptor);
        static TString AttrPhoneNumber(const TDbProfile* profile, TDbIndex phoneId);
        static TString AttrPhoneBornDate(const TDbProfile* profile, TDbIndex phoneId);
        static TString AttrProtectionLevel(const TDbProfile* profile,
                                           TDbIndex hintQId,
                                           TDbIndex hintAId,
                                           TDbIndex pwdQualityId,
                                           TDbIndex strongPolicyId,
                                           TDbIndex pwdHashId,
                                           TDbIndex totpSecretId);
        static TString AttrRfC2FaOnFunc(const TDbProfile* profile, TDbIndex secret);
        static TString AttrHavePlus(const TDbProfile* profile, TDbIndex plusEna);
        static TString AttrConnectOrganizationIds(const TDbProfile* profile,
                                                  TDbIndex externalIds);
        static TString AttrPDDOrganizationId(const TDbProfile* profile);
        TString AttrSuggestPublicName(const TDbProfile* profile,
                                      TDbIndex firstname,
                                      TDbIndex lastname,
                                      TDbIndex displayname,
                                      TDbIndex dontUseDisplayName,
                                      TDbIndex showFIO,
                                      TDbIndex registrationTime) const;
        static TString AttrHasCustomPublicId(const TDbProfile* profile,
                                             TDbIndex publicId);
        static TString AttrPlusMappedSubscriptionLevel(const TDbProfile* profile, TDbIndex plusLevel);
        static TString AttrAccountCompletionRecommended(const TDbProfile* profile,
                                                        TDbIndex neophonish,
                                                        TDbIndex portal,
                                                        TDbIndex firstname,
                                                        TDbIndex lastname);
        static TString AttrAccountFamilyChildrenManagement(const TDbProfile* profile, TDbIndex realAttr);
        static TString AttrAccountIsKid(const TDbProfile* profile);

        static TString ProxyAttr(const TDbProfile* profile, TDbIndex idx);
        static TString DefaultValueAttr(const TDbProfile* profile, TDbIndex mainAttr, TDbIndex defAttr);

        static bool HasProfileStrongPwd(const TDbProfile* profile,
                                        TDbIndex pwdQualityId,
                                        TDbIndex strongPolicyId);
        static bool HasProfileRestoreEmail(const TDbProfile* profile);
        static bool HasProfileRestorePhone(const TDbProfile* profile);

        // synthetic extended attributes functions
        static TString AttrExtGetAttribute(const TDbProfile* profile,
                                           const TString& entityId,
                                           const TString& type,
                                           const TString& attr);
        static TString AttrExtHasAttribute(const TDbProfile* profile,
                                           const TString& entityId,
                                           const TString& type,
                                           const TString& attr);
        static TString AttrExtFormattedNumber(const TDbProfile* profile,
                                              const TString& entityId);
        static TString AttrExtE164Number(const TDbProfile* profile,
                                         const TString& entityId);
        static TString AttrExtMaskedFormattedNumber(const TDbProfile* profile,
                                                    const TString& entityId);
        static TString AttrExtMaskedE164Number(const TDbProfile* profile,
                                               const TString& entityId);
        static TString AttrExtPhoneIsDefault(const TDbProfile* profile,
                                             const TString& entityId);
        static TString AttrExtPhoneIsBank(const TDbProfile* profile,
                                          const TString& entityId);

        time_t FullFioStartTime_;

        TProxyAttrsMap ProxyAttributes_;
    };
}
