#pragma once

#include <passport/infra/libs/cpp/cache/cache.h>
#include <passport/infra/libs/cpp/cache/cache_holder.h>
#include <passport/infra/libs/cpp/tvm/signer/signer.h>

namespace NPassport::NCache {
    template <>
    inline size_t GetSizeOf<NTicketSigner::TUserSigner>(const NTicketSigner::TUserSigner& value) {
        return value.size();
    }
}

namespace NPassport::NBb {
    class TUserTicketCache {
    public:
        using TCache = NCache::TCachePtr<NTicketSigner::TUserSigner, TString>;

        TUserTicketCache(TCache cache, TDuration lifeTime, bool isDryRun)
            : Cache(std::move(cache))
            , LifeTime(lifeTime)
            , IsDryRun(isDryRun)
        {
        }

        class TCacheHolder: public NCache::TCacheHolder<NTicketSigner::TUserSigner, TString> {
            using TBase = NCache::TCacheHolder<NTicketSigner::TUserSigner, TString>;

        public:
            TCacheHolder() = default;

            TCacheHolder(TCacheHolder&&) = default;
            TCacheHolder& operator=(TCacheHolder&&) = default;

            using TBase::TBase;
        };

        TCacheHolder GetCache() const {
            return TCacheHolder(Cache, LifeTime, IsDryRun);
        }

        TCache Cache;

        const TDuration LifeTime;
        const bool IsDryRun;
    };
}
