#pragma once

#include <passport/infra/daemons/blackbox/src/grants/consumer.h>

#include <util/generic/strbuf.h>
#include <util/generic/string.h>

#include <vector>

namespace NPassport::NDbPool {
    class TNonBlockingHandle;
    class TResult;
}

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NBb {
    class TAttributesSettings;
    class TDbFetcher;
    class TDbFieldsSettings;
    class TYandexDomains;

    enum class ESanitizeStatus {
        Ok,
        TooLong,
        InvalidChars,
    };

    class TUtils {
    public:
        static ESanitizeStatus SanitizeLogin(const TStringBuf login, size_t maxLoginSize = 255);
        static TString NormalizeLogin(const TStringBuf login);
        static TString NormalizeTotp(const TStringBuf s);
        static void DotsToHyphens(TString& s, bool convertEmailsAsWell);

        static i64 ToInt(TStringBuf strval, TStringBuf name);
        static ui64 ToUInt(TStringBuf strval, TStringBuf name);
        static time_t ToTime(TStringBuf strval);

        static void CheckArgValue(const TString& val, const TString& arg);
        static void CheckUserIpArg(const NCommon::TRequest& request);

        static const TString& GetCheckedArg(const NCommon::TRequest& request, const TString& arg);
        static TString GetCheckedArgSession(const NCommon::TRequest& request, const TString& arg);
        static TString GetUserIpArg(const NCommon::TRequest& request);
        static const TString& GetUserPortArg(const NCommon::TRequest& request);
        static bool GetBoolArg(const NCommon::TRequest& request, const TString& arg);

        static const TString& GetIntArg(const NCommon::TRequest& request, const TString& arg, bool mandatory = false);
        static const TString& GetUIntArg(const NCommon::TRequest& request, const TString& arg, bool mandatory = false);

        static std::vector<TString> GetNumbersArgChecked(const TStringBuf argValue,
                                                         const TStringBuf аrgName);
        static void CheckFindByPhoneAliasArg(const NCommon::TRequest& request, TDbFetcher& fetcher);

        static TString SanitizePhoneNumber(const TStringBuf number);

        static TString NormalizePhone(const TStringBuf phone,
                                      const TString& domain,
                                      const TYandexDomains& yandexDomains,
                                      const TString& cntr = {});
        static TString GetDigitsOnly(const TStringBuf phone);
        static TString NormalizePhoneByLegacyWay(const TString& phone,
                                                 const TStringBuf domain);
        static TString MaskPhoneNumber(TString&& phone);

        static TString FixPythonTimestamp(const TString& ts);

        static std::unique_ptr<NDbPool::TResult> WaitResult(NDbPool::TNonBlockingHandle& handle, const char* errorMsg);

        static TString SelectGreeting(const TString& accountLogin, const TString& sid8Login, bool mismatchExpected = false);
        static bool IsSyntheticLogin(const TStringBuf login);
        static TString& MakeEmail(TString& buf, const TStringBuf login, const TStringBuf domain);

        static void CheckUserTicketAllowed(const NCommon::TRequest& req);
        static void ThrowOnLeadingZeroInNumber(TStringBuf value, TStringBuf argName);

        static bool HasLetter(const TStringBuf str, bool allowUTF = false);
        static TString TolowerUtf(const TStringBuf str);
    };
}
