#pragma once

#include <util/generic/string.h>

#include <map>
#include <set>
#include <vector>

namespace NPassport::NBb {
    class TYandexDomains {
    public:
        class TDomainData {
        public:
            TDomainData(const TString& name, bool anyCountry = false);

            const TString& Name() const;
            void Add(const TString& country);
            void SetAny(bool bAny);
            void SetSid(const TString& sid);
            void SetDomid(const TString& domid);
            bool Visible(const TString& country) const;
            const TString& GetSid() const;
            const TString& GetDomid() const;
            void SetPhoneCountry(const TString& country);
            const TString& GetPhoneCountry() const;

        private:
            TString Name_;                // domain name
            bool BAnyCountry_;            // true if visible to all countries
            std::set<TString> Countries_; // countries that see this domain
            TString Sid_;
            TString Domid_;
            TString PhoneCountry_; // ISO 3166
        };

        // map: normalized punicoded domain -> actual domain data
        using TCont = std::map<TString, TDomainData>;
        using TContIt = TCont::const_iterator;

        TYandexDomains();

        class TShowIterator {
        public:
            const TString& operator*() const;
            const TString* operator->() const;
            TShowIterator& operator++();
            TShowIterator operator++(int);
            bool operator==(const TShowIterator& other) const;
            bool operator!=(const TShowIterator& other) const;
            bool Visible(const TString& country) const;
            const TString& AltDomId() const;

        private:
            friend class TYandexDomains;
            TShowIterator(TYandexDomains::TContIt);
            TYandexDomains::TContIt It_;
        };

        const TString& Insert(const TString&);
        const TString& Insert(const TDomainData&);
        const TDomainData* Find(const TString&) const;
        TShowIterator begin() const;
        TShowIterator end() const;

        void SetOtherCountryDefault(const TString& otherCountry);
        void AddDefault(const TString& country, const TString& domain);
        const TString& DefaultDomain(const TString& country) const;
        const TString& AltDomain(const TString& id) const;

        size_t DomainCount() const;

    private:
        // map: country -> default email for this country
        using TDefaultMapType = std::map<TString, TString>;

        // map: alt domain id -> alt domain name
        using TAltDomainsMapType = std::map<TString, TString>;

        TCont Domains_;

        TDefaultMapType DefaultMap_;
        TAltDomainsMapType AltDomainsMap_;
        TString OtherCountryDefault_;
    };

}
