#pragma once

#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NXml {
    class TConfig;
}

namespace NPassport::NBb {
    class TOAuthScopesConfig;
    class TOAuthTokenInfo;
    class TShardsMap;
    class TTskvLog;

    class TOAuthStatboxMsg {
    public:
        static const TString ERROR;

        static const TString CLIENT_BLOCKED;
        static const TString CLIENT_GLOGOUT;
        static const TString CLIENT_NOT_FOUND;
        static const TString SCOPES_EMPTY;
        static const TString SCOPES_WRONG;
        static const TString TOKEN_EXPIRED;
        static const TString USER_DISABLED;
        static const TString USER_GLOGOUT;
        static const TString USER_NOT_FOUND;
        static const TString USER_PWD_CREATE;
        static const TString USER_PWD_CHANGE;
        static const TString USER_PWD_EXPIRED;
        static const TString USER_REVOKED_TOKENS;
        static const TString USER_IS_CHILD;
        static const TString USER_FEDERAL;
        static const TString USER_ROBOT;
    };

    class TOAuthConfig {
    public:
        TOAuthConfig(TTskvLog& oauthLog);
        ~TOAuthConfig();

        void Init(const NXml::TConfig& config,
                  const TString& xpathPrefix,
                  std::shared_ptr<NDbPool::TDbPoolCtx> ctx);

        bool DbOk(TString& msg) const;

        void LogOAuth(const TOAuthTokenInfo& info,
                      const TString& userip,
                      const TString& status,
                      const TString& reason,
                      const TString& consumer,
                      const TString& consumerIp) const;
        void LogOAuthErrorByAlias(const TString& uid,
                                  const TString& reason,
                                  const TString& userip,
                                  const TString& consumer,
                                  const TString& consumerIp) const;

    private:
        friend class TOAuthBaseFetcher;
        friend class TOAuthSingleFetcher;
        friend class TOAuthMultiFetcher;
        TTskvLog& OauthLogger_;

        double TokenRefreshRatio_ = 0.5;
        TString AvatarsUrlPrefix_;
        std::unique_ptr<TOAuthScopesConfig> Scopes_;

        std::shared_ptr<NDbPool::TDbPool> OauthCentral_;
        std::unique_ptr<TShardsMap> OauthShards_;
    };

}
