#pragma once

#include "status.h"

#include <passport/infra/libs/cpp/auth_core/oauth_token.h>

#include <util/generic/string.h>

namespace NPassport::NBb {
    class TOAuthError {
    public:
        enum EError {
            Ok = 0,
            WrongScope,
            AccountNotFound,
            AccountDisabled,
            ExpiredPassword,
            GLogout,
            Revoked,
            PasswordChangeRequired,
            PasswordCreateRequired,
            OAuthReject,
            TokenExpired,
            ClientNotFound,
            ClientBlocked,
            ChildAccount,
            FederalAccount,
            ExternalRobot,
            WrongEnvironment,
        };

        TOAuthError(EError err = Ok);

        const TString& Msg() const;
        EError Error() const;

        void SetMsg(TString&& msg, EError st);
        void SetMsg(TString&& msg, NAuth::TOAuthToken::EStatus st);
        void SetError(EError st);
        void SetError(NAuth::TOAuthToken::EStatus st);

        TString AuthLogErrorComment(const TString& tokenId) const;

        TOAuthStatus ConvertToStatus() const;

    private:
        static const TString OK;
        static const TString ACCOUNT_NOT_FOUND;
        static const TString ACCOUNT_DISABLED;
        static const TString EXPIRED_PASSWORD;
        static const TString GLOGOUT;
        static const TString REVOKED;
        static const TString PASSWORD_CHANGE_REQUIRED;
        static const TString PASSWORD_CREATE_REQUIRED;
        static const TString EXPIRED_TOKEN;
        static const TString CLIENT_NOT_FOUND;
        static const TString CLIENT_BLOCKED;
        static const TString CHILD_ACCOUNT;
        static const TString FEDERAL_ACCOUNT;
        static const TString EXTERNAL_ROBOT;

        EError Error_;
        TString Msg_;
    };
}
