#pragma once

#include "error.h"
#include "fetcher.h"

#include <unordered_map>

namespace NPassport::NBb {
    class TOAuthMultiFetcher: public TOAuthBaseFetcher {
    public:
        struct TToken {
            std::unique_ptr<TOAuthTokenInfo> Info;
            TOAuthError Error;
        };

        using TTokenId = ui32;
        using TClientId = ui32;
        using TTokens = std::map<TTokenId, TToken>;

        using TDbHandles = std::vector<NDbPool::TNonBlockingHandle>;

        struct TTokenIdsForClientId {
            std::vector<TTokenId> Ids;
            bool WasFound = false;

            bool operator==(const TTokenIdsForClientId& o) const;
        };
        using TClientIdIndex = std::unordered_map<TClientId, TTokenIdsForClientId>;

    public:
        TOAuthMultiFetcher(const TOAuthConfig& config);

        TDbHandles SendRequestForTokenAttrs(const TStringBuf uid,
                                            const std::optional<TClientId> clientId,
                                            const TStringBuf deviceId) const;
        TTokens WaitTokenAttrs(TDbHandles handles) const;

        TTokens FetchClientAttrs(TTokens tokens) const;

    public:
        static TString BuildShardQuery(const TStringBuf uid,
                                       const std::optional<TClientId> clientId,
                                       const TStringBuf deviceId,
                                       NDbPool::TNonBlockingHandle& handle);

        static TClientIdIndex BuildIndex(const TTokens& tokens);
        TString BuildCentralQuery(const TClientIdIndex& idx) const;

        void ReadTokenAttrRow(const NDbPool::TRow& row, TTokens& out) const;
        TTokens FinishProcessingForTokenAttributes(TTokens tokens) const;

        TClientId ReadClientAttrRow(const NDbPool::TRow& row,
                                    const TClientIdIndex& idx,
                                    TTokens& out) const;
        static TTokens FinishProcessingForClientAttributes(TTokens tokens, const TClientIdIndex& idx);

    protected:
        void LogOAuth(const TOAuthTokenInfo& info,
                      const TString& status,
                      const TString& reason) const override;
    };
}
