#pragma once

#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/generic/string.h>
#include <util/system/types.h>

#include <memory>
#include <unordered_map>
#include <unordered_set>

namespace NPassport::NUtils {
    class TFileLoader;
}

namespace NPassport::NBb {
    class TOAuthSingleScope {
    public:
        TOAuthSingleScope(TString&& keyword);

        const TString& Keyword() const {
            return Keyword_;
        }

        ui32 Ttl() const {
            return Ttl_;
        }

        bool IsXToken() const {
            return IsXToken_;
        }

        bool IsDeleted() const {
            return IsDeleted_;
        }

        static const size_t MAX_KEYWORD_SIZE = 50;

    protected:
        TString Keyword_;
        ui32 Ttl_ = 0;
        bool IsXToken_ = false;
        bool IsDeleted_ = false;

        friend class TOAuthScopesConfig;
    };

    class TOAuthScopes {
    public:
        TOAuthScopes(const TString& keywordList,
                     bool isXToken = false,
                     ui32 ttl = 0,
                     const std::unordered_set<TString>& scopeCollection = {})
            : KeywordList_(keywordList)
            , Ttl_(ttl)
            , ScopeCollection_(scopeCollection)
            , IsXToken_(isXToken)
        {
        }

        TOAuthScopes() = default;

        void Reserve(unsigned n);

        ui32 Ttl() const {
            return Ttl_;
        }

        const TString& KeywordList() const {
            return KeywordList_;
        }

        const std::unordered_set<TString>& ScopeCollection() const {
            return ScopeCollection_;
        }

        bool IsXToken() const {
            return IsXToken_;
        }

        void AddScope(const TOAuthSingleScope& scope);

    private:
        TString KeywordList_;
        ui32 Ttl_ = 0;
        std::unordered_set<TString> ScopeCollection_;
        bool IsXToken_ = false;
    };

    class TOAuthScopesConfig {
    public:
        using TScopes = std::unordered_map<TString, TOAuthSingleScope>;

        TOAuthScopes GetScopesFromNums(const TString& numsContainer) const;
        TOAuthScopes GetScopesFromIds(const std::unordered_set<ui32>& ids) const;

        TOAuthScopesConfig(const TString& path, ui32 period);
        ~TOAuthScopesConfig();

    private:
        void Update(const TStringBuf fileBody);
        static std::shared_ptr<TScopes> Parse(const TStringBuf fileBody);
        static TOAuthSingleScope LoadScope(rapidjson::Value& jsonValue);

        const TString Path_;
        NUtils::TSharedState<TScopes> Scopes_;
        TOAuthSingleScope DefaultScope_;

        // must be last member
        std::unique_ptr<NUtils::TFileLoader> Loader_;
    };
}
