#include "status.h"

namespace NPassport::NBb {
    static const TString VALID = "VALID";
    static const TString DISABLED = "DISABLED";
    static const TString INVALID = "INVALID";

    const TString& TOAuthStatus::AsString() const {
        return AsString(Status_);
    }

    const TString& TOAuthStatus::AsString(EStatus status) {
        switch (status) {
            case EStatus::Valid:
                return VALID;
            case EStatus::Disabled:
                return DISABLED;
            case EStatus::Invalid:
                return INVALID;
        }
    }

    TAuthLog::EFlag TOAuthStatus::GetAuthLogStatus() const {
        return GetAuthLogStatus(Status_);
    }

    TAuthLog::EFlag TOAuthStatus::GetAuthLogStatus(EStatus status) {
        switch (status) {
            case EStatus::Valid:
                return TAuthLog::OK;
            case EStatus::Disabled:
                return TAuthLog::DISABLED;
            case EStatus::Invalid:
                return TAuthLog::BAD;
        }
    }
}
