#pragma once

#include <passport/infra/daemons/blackbox/src/loggers/authlog.h>

namespace NPassport::NBb {
    class TOAuthStatus {
    public:
        enum EStatus {
            Valid = 0,    // valid, all data present
            Disabled = 4, // invalid, no data, account is disabled
            Invalid = 5,  // invalid, all other cases (sign broken, garbage, etc.)
        };

        TOAuthStatus(EStatus status = EStatus::Invalid)
            : Status_(status)
        {
        }

        EStatus Status() const {
            return Status_;
        }

        const TString& AsString() const;
        static const TString& AsString(EStatus status);

        TAuthLog::EFlag GetAuthLogStatus() const;
        static TAuthLog::EFlag GetAuthLogStatus(EStatus status);

        bool operator==(const TOAuthStatus& o) const {
            return Status_ == o.Status_;
        }

    private:
        EStatus Status_;
    };
}
