#pragma once

#include <passport/infra/libs/cpp/auth_core/environment.h>

#include <util/generic/string.h>

#include <optional>

namespace NPassport::NBb {
    class TOAuthTokenEmbeddedInfo {
    public:
        static TOAuthTokenEmbeddedInfo Parse(const TString& token);

        bool HasInfo() const {
            return HasInfo_;
        }

        bool IsOk() const {
            return ErrMsg_.empty();
        }

        const TString& ErrMsg() const {
            return ErrMsg_;
        }

        ui64 Uid() const {
            return Uid_;
        }

        ui32 ClientId() const {
            return ClientId_;
        }

        std::optional<ui64> TokenId() const {
            return TokenId_;
        }

        std::optional<NAuth::EEnvironmentType> Environment() const {
            return Environment_;
        }

        ui8 Shard() const {
            return Shard_;
        }

    private:
        static TOAuthTokenEmbeddedInfo ParseV2(const TString& token);
        static TOAuthTokenEmbeddedInfo ParseV3(const TString& token);

    private:
        bool HasInfo_ = false;
        TString ErrMsg_;

        ui64 Uid_ = 0;
        ui32 ClientId_ = 0;
        std::optional<ui64> TokenId_;
        std::optional<NAuth::EEnvironmentType> Environment_;
        ui8 Shard_ = 0;
    };
}
