#pragma once

#include "scopes.h"

#include <passport/infra/libs/cpp/auth_core/oauth_token.h>

#include <util/generic/string.h>

#include <unordered_map>

namespace NPassport::NBb {
    class TOAuthError;
    class TOAuthScopes;
    class TOAuthScopesConfig;

    class TOAuthTokenInfo {
    public:
        TOAuthTokenInfo(bool byAlias = false);
        TOAuthTokenInfo(const NAuth::TOAuthToken& token, const TString& strtoken, const TOAuthScopesConfig& scopes);

        TString AuthLogComment(const TStringBuf userPort = {}, ui32 consumerTvmId = 0) const;

        bool HasScopes(const TString& scopes, TOAuthError* error = nullptr) const;

        void SetScopes(TOAuthScopes&& scopes);
        void SetRefreshRequired(double refreshRatio);

        void SetTokenAttr(const TString& name, TString&& value);
        void SetClientAttr(const TString& name, TString&& value);

        bool HasTokenAttr(const TString& name) const;
        bool HasClientAttr(const TString& name) const;

        const TString& GetTokenAttr(const TString& name) const;
        const TString& GetClientAttr(const TString& name) const;

        void SetCreateTs(const TString& value);
        void SetIssueTs(const TString& value);
        void SetExpireTs(const TString& value);
        void SetIssueTs(time_t value);
        void SetExpireTs(time_t value);

        time_t GetMinimumIssueTime() const;

        bool IsXTokenTrusted() const;

        TString GetLoginId() const;

        const TString& GetScopesKeywordList() const;
        const std::unordered_set<TString>& GetScopeCollection() const;
        bool IsXToken() const;

        void AddScope(const TOAuthSingleScope& scope);

        TString TokenId;

        TString Uid;

        TString DeviceId;
        TString ScopesComma;

        // human readable date strings
        TString CreateTime;
        TString IssueTime;
        TString ExpireTime;
        // timestamp values for dates
        time_t CreateTimeTs = 0;
        time_t IssueTimeTs = 0;
        time_t ExpireTimeTs = 0;
        time_t XtokenIssueTimeTs = 0;

        bool IsRefreshRequired = false;
        bool IsTtlRefreshable = false;

        TString ClientIcon;
        TString ClientCreatetime;
        bool ClientIsYandex = false;

        bool NullExpire = false;

        bool ByAlias = false;

        bool ShowIsXTokenTrusted = true;

        using TAttrMap = std::unordered_map<TString, TString>;

        TAttrMap TokenAttrs;
        TAttrMap ClientAttrs;

    private:
        TOAuthScopes OAuthScopes_;
    };
}
