#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NBb {
    class TAuthChunk: TMoveOnly {
    public:
        TAuthChunk(long int passwordVerificationAge,
                   const TString& profileId,
                   bool havePassword,
                   bool scholar)
            : PasswordVerificationAge(passwordVerificationAge)
            , ProfileId(profileId)
            , HavePassword(havePassword)
            , Scholar(scholar)
        {
        }

        const long int PasswordVerificationAge = -1;
        const TString ProfileId;
        const bool HavePassword = false;
        const bool Scholar = false;
    };

}
