#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NBb {
    class TAuthIdChunk: TMoveOnly {
    public:
        TAuthIdChunk() = default;

        TAuthIdChunk(const TString& id,
                     const TString& timestamp,
                     const TString& ip,
                     const TString& host)
            : Id(id)
            , Timestamp(timestamp)
            , Ip(ip)
            , Host(host)
        {
        }

        const TString Id;
        const TString Timestamp;
        const TString Ip;
        const TString Host;
    };
}
