#pragma once

#include "account_chunk.h"
#include "attributes_chunk.h"
#include "billing_features_chunk.h"
#include "dbfields_chunk.h"
#include "display_name_chunk.h"
#include "emails_chunk.h"
#include "ext_attrs_chunk.h"
#include "family_info_chunk.h"
#include "karma_chunk.h"
#include "phone_bindings_chunk.h"
#include "phone_operations_chunk.h"
#include "plus_subscriber_state_chunk.h"
#include "uid_chunk.h"

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NBb {
    class TBaseResult: TMoveOnly {
    public:
        std::unique_ptr<TUidChunk> Uid;
        std::unique_ptr<TAccountChunk> Account;
        std::unique_ptr<TKarmaChunk> Karma;
        std::unique_ptr<TDisplayNameChunk> DisplayName;
        std::unique_ptr<TDbFieldsChunk> Dbfields;
        std::unique_ptr<TAttributesChunk> Attributes;
        std::unique_ptr<TEmailsChunk> Emails;
        std::unique_ptr<TExtAttrsChunk> PhoneAttrs;
        std::unique_ptr<TExtAttrsChunk> EmailAttrs;
        std::unique_ptr<TExtAttrsChunk> WebauthnAttrs;
        std::unique_ptr<TPhoneOperationsChunk> PhoneOperations;
        std::unique_ptr<TPhoneBindingsChunk> PhoneBindings;
        std::unique_ptr<TBillingFeaturesChunk> BillingFeatures;
        std::unique_ptr<TPlusSubscriberStateChunk> PlusSubscriberState;
        std::unique_ptr<TFamilyInfoChunk> FamilyInfo;

        // Just a string so far, maybe convert to chunk later
        std::unique_ptr<TString> PublicId;

        TString UserTicket;
    };
}
