#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <map>
#include <optional>

namespace NPassport::NBb {
    class TBillingFeaturesChunk: TMoveOnly {
    public:
        struct TFeatureAttributes {
            std::optional<bool> InTrial;
            std::optional<ui32> TrialDuration;
            std::optional<bool> PaidTrial;
            std::optional<ui32> RegionId;
            std::optional<TString> Brand;
        };

        // map: feature name -> feature attributes
        using TBillingFeatures = std::map<TString, TFeatureAttributes>;

        TBillingFeatures Features;
    };
}
