#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>
#include <optional>

namespace NPassport::NBb {
    class TPublicNameData {
    public:
        TString Name;
        bool HasPublicProfile = false;
        bool ThirdPartyCanUse = false;
    };

    class TDisplayNameChunk: TMoveOnly {
    public:
        // TODO: move out any logic from ctor
        TDisplayNameChunk(const TString& avatarId, bool verified)
            : Avatar(avatarId.empty() ? "0/0-0" : avatarId)
            , IsAvatarEmpty(avatarId.empty())
            , Verified(verified)
        {
        }

        void SetSocial(TString&& profileId,
                       TString&& provider,
                       TString&& target) {
            Social = true;
            ProfileId = std::move(profileId);
            Provider = std::move(provider);
            Target = std::move(target);
        }

        void SetDisplayName(const TString& name,
                            bool isEmpty,
                            bool emptinessRequired) {
            DisplayName = name;
            if (emptinessRequired) {
                IsDisplayNameEmpty = isEmpty;
            }
        }

        TString Regname;
        TString DisplayName;

        const TString Avatar;
        const bool IsAvatarEmpty;
        const bool Verified;

        bool Social = false;
        TString ProfileId;
        TString Provider;
        TString Target;

        std::optional<bool> IsDisplayNameEmpty;

        std::optional<TPublicNameData> PublicName;
    };
}
