#pragma once

#include <passport/infra/daemons/blackbox/src/misc/strings.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

namespace NPassport::NBb {
    class TEditTotpResult: TMoveOnly {
    public:
        const TString& Error() const {
            return Error_;
        }

        const TString& SecretValue() const {
            return SecretValue_;
        }

        const TString& JunkSecretValue() const {
            return JunkSecretValue_;
        }

        const TString& CheckTime() const {
            return CheckTime_;
        }

        void SetError(const TString& error) {
            Error_ = error;
        }

        void SetSecretValue(const TString& secretValue, const TString& checkTime) {
            SecretValue_ = secretValue;
            CheckTime_ = checkTime;
        }

        void SetJunkSecretValue(const TString& junkSecretValue) {
            JunkSecretValue_ = junkSecretValue;
        }

    private:
        TString Error_ = TStrings::OK;
        TString SecretValue_;
        TString JunkSecretValue_;
        TString CheckTime_;
    };
}
