#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <map>
#include <vector>

namespace NPassport::NBb {
    class TExtAttrsChunk: TMoveOnly {
    public:
        // list of pairs: (attribute type, attribute value)
        using TAttrs = std::vector<std::pair<TString, TString>>;
        // list of pairs: entity id, extended attrs
        using TExtAttrs = std::vector<std::pair<TString, TAttrs>>;

        TExtAttrsChunk(TExtAttrs&& attrs)
            : Attrs(std::move(attrs))
        {
        }

        const TExtAttrs Attrs;
    };
}
