#pragma once

#include "base_result.h"

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <optional>
#include <vector>

namespace NPassport::NBb {
    class TFamilyInfoResult: TMoveOnly {
    public:
        struct TStatus {
            TString Value;
            TString Description;
        } Status;

        TString FamilyId;
        TString AdminUid;
        std::optional<bool> AllowMoreKids;

        struct TUser {
            TString Uid;
            std::optional<TString> Place;
            bool IsChild = false;
            bool IsKid = false;
            std::shared_ptr<TBaseResult> BaseResult;

            bool operator==(const TUser& o) const noexcept {
                return Uid == o.Uid && Place == o.Place;
            }
        };
        std::vector<TUser> Users;
    };
}
