#pragma once

#include <passport/infra/libs/cpp/auth_core/session_errors.h>

#include <util/generic/string.h>

namespace NPassport::NBb {
    class TAllTracksResult;
    class TBlackboxError;
    class TBulkUserInfoResult;
    class TCheckDeviceSignatureResult;
    class TCheckHasPlusResult;
    class TCheckGrantsResult;
    class TCheckRfcTotpResult;
    class TCheckSignResult;
    class TCreateOAuthTokenResult;
    class TCreateSessionResult;
    class TDecreaseSessionidLifetimeResult;
    class TEditTotpResult;
    class TFamilyInfoResult;
    class TFindByPhoneNumbersResult;
    class TGetDebugUserTicketResult;
    class TGetDevicePublicKeyResult;
    class TGetMaxUidResult;
    class TGetOAuthTokensResult;
    class TLCookieResult;
    class TListResult;
    class TLoginOccupationResult;
    class TLoginResult;
    class TOAuthResult;
    class TPhoneBindingsResult;
    class TProveKeyDiagResult;
    class TPwdHistoryResult;
    class TSessionResult;
    class TTableResult;
    class TTestPwdHashesResult;
    class TTrackResult;
    class TTypedValueResult;
    class TUserTicketResult;
    class TWebauthnCredentialsResult;
    struct TExceptionInfo;

    class TJsonSerializer {
    public:
        static TString Serialize(const TOAuthResult& result);
        static TString Serialize(const TSessionResult& result);
        static TString Serialize(const TBulkUserInfoResult& result);
        static TString Serialize(const TLoginResult& result);
        static TString Serialize(const TTypedValueResult& result);
        static TString SerializeException(const TExceptionInfo& info);
        static TString Serialize(const TListResult& result);
        static TString Serialize(const TTableResult& result);
        static TString Serialize(const TCreateSessionResult& result);
        static TString Serialize(const TLoginOccupationResult& result);
        static TString Serialize(const TLCookieResult& result);
        static TString Serialize(const TTestPwdHashesResult& result);
        static TString Serialize(const TTrackResult& result);
        static TString Serialize(const TProveKeyDiagResult& result);
        static TString Serialize(const TEditTotpResult& result);
        static TString Serialize(const TPwdHistoryResult& result);
        static TString Serialize(const TPhoneBindingsResult& result);
        static TString Serialize(const TAllTracksResult& result);
        static TString Serialize(const TCreateOAuthTokenResult& result);
        static TString Serialize(const TCheckRfcTotpResult& result);
        static TString Serialize(const TCheckSignResult& result);
        static TString Serialize(const TCheckDeviceSignatureResult& result);
        static TString Serialize(const TGetDevicePublicKeyResult& result);
        static TString Serialize(const TCheckHasPlusResult& result);
        static TString Serialize(const TFamilyInfoResult& result);
        static TString Serialize(const TFindByPhoneNumbersResult& result);
        static TString Serialize(const TUserTicketResult& result);
        static TString Serialize(const TWebauthnCredentialsResult& result);
        static TString Serialize(const TGetMaxUidResult& result);
        static TString Serialize(const TGetDebugUserTicketResult& result);
        static TString Serialize(const TGetOAuthTokensResult& result);
        static TString Serialize(const TDecreaseSessionidLifetimeResult& result);
        static TString SerializeCheckGrants(const TCheckGrantsResult& result,
                                            const TExceptionInfo* info = nullptr);
    };
}
