#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NBb {
    class TListResult: TMoveOnly {
    public:
        using TStringVector = std::vector<TString>;

        TListResult(const TString& name,
                    const TString& propertyName = TListResult::PROPERTY_NAME)
            : Name(name)
            , PropertyName(propertyName)
        {
        }

        const TString Name;
        const TString PropertyName;

        int TotalCount = 0;
        TStringVector Data;

    private:
        static inline const TString PROPERTY_NAME = "id";
    };
}
