#pragma once

#include "badauth_counters_chunk.h"
#include "base_result.h"

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <ctime>
#include <memory>
#include <optional>
#include <vector>

namespace NPassport::NBb {
    class TLoginResult: public TBaseResult {
    public:
        enum EResistPolicy {
            None = 0,
            Captcha = 1,
            Delay = 2,
            Expired = 3
        };

        const TString& ResistPolicyName() const {
            switch (ResistPolicy) {
                case Captcha:
                    return CAPTCHA;
                case Delay:
                    return DELAY;
                case Expired:
                    return EXPIRE;
                case None:
                    return NONE;
            }
        }

        int LoginStatus = -1;
        TString LoginStatusStr;
        int PasswordStatus = -1;
        TString PasswordStatusStr;
        TString Comment;
        int ApiVersion = 1;
        EResistPolicy ResistPolicy = None;
        unsigned long ResistDelay = 0;
        bool RestrictSession = false;
        std::time_t TotpCheckTime = 0;
        TString ConnectionId;
        std::optional<TString> AllowedSecondSteps;
        std::optional<TBadauthCountersChunk> BadauthCounts;
        bool ScholarSession = false;

    private:
        static inline const TString NONE = "none";
        static inline const TString CAPTCHA = "captcha";
        static inline const TString DELAY = "delay";
        static inline const TString EXPIRE = "password_expired";
    };
}
