#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <map>

namespace NPassport::NBb {
    class TLoginOccupationStatus: TMoveOnly {
    public:
        enum EStatus {
            Free,
            Stop,
            Busy,
            Malformed,
            PublicId
        };

        TLoginOccupationStatus(EStatus st, const TString& uid = {})
            : Status(st)
            , Uid(uid)
        {
        }

        const TString& StatusName() const {
            switch (Status) {
                case Free:
                    return FreeResultStr;
                case Stop:
                    return StopListResultStr;
                case Busy:
                    return OccupiedResultStr;
                case Malformed:
                    return MalformedResultStr;
                case PublicId:
                    return PublicIdResultStr;
            };
        }

        EStatus Status;
        TString Uid;

    private:
        static inline const TString FreeResultStr = "free";
        static inline const TString StopListResultStr = "stoplist";
        static inline const TString OccupiedResultStr = "occupied";
        static inline const TString MalformedResultStr = "malformed";
        static inline const TString PublicIdResultStr = "public_id";
    };

    using TLoginOccupationStatusMap = std::map<TString, TLoginOccupationStatus>;

    class TLoginOccupationResult: TMoveOnly {
    public:
        TLoginOccupationResult() = default;

        TLoginOccupationStatusMap Statuses;
    };
}
