#pragma once

#include <passport/infra/daemons/blackbox/src/misc/experiment.h>

#include <passport/infra/libs/cpp/auth_core/session.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NBb {
    class TNewSessionChunk: TMoveOnly {
        static time_t GetExpireTs(const NAuth::TSession& s) {
            if (s.IsSession()) {
                return 0;
            }
            // 'new permanent' cookes should expire in 2038
            if (s.Ttl() == "5") {
                return std::numeric_limits<i32>::max();
            }

            // set expires relative to cookie create time
            return s.Ts() + s.GetExpireTime();
        }

    public:
        // to set new cookie
        TNewSessionChunk(NAuth::TSession& sess, const TString& domain, bool resign)
            : Domain(domain)
        {
            if (resign) {
                sess.Resign();
            }
            Expires = GetExpireTs(sess);
            Value = sess.AsString(NAuth::TSession::ECategory::Actual);

            LegacyValue = sess.AsString(NAuth::TSession::ECategory::Legacy);
            if (std::hash<TString>{}(sess.AuthId()) % 100 < TExperiment::Get().InvalidSessionidRate) {
                size_t pos = LegacyValue.rfind('.');
                Y_VERIFY(pos != TString::npos);
                LegacyValue.resize(pos + 1);
                LegacyValue.append("fakesign0000000000000000000");
            }
        }

        // to delete cookie
        TNewSessionChunk(const TString& domain)
            : Domain(domain)
            , Expires(1)
        {
        }

        TString Value;
        TString LegacyValue;
        TString Domain;
        unsigned int Expires;
    };
}
