#pragma once

#include "auth_chunk.h"
#include "authid_chunk.h"
#include "base_result.h"
#include "new_session_chunk.h"
#include "resigned_cookies.h"
#include "sessguard_chunk.h"

#include <passport/infra/daemons/blackbox/src/misc/session_utils.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>
#include <vector>

namespace NPassport::NBb {
    class TSessionUser: public TBaseResult {
    public:
        const TString& StatusStr() const {
            return TSessionUtils::StatusName(Status);
        }

        std::optional<TSessionidProcessor::ESessionStatus> Status;
        TString Comment;
        std::unique_ptr<TAuthChunk> Auth;
        std::optional<bool> IsRegCompletionRecommended;
    };
    using TSessionUserPtr = std::unique_ptr<TSessionUser>;

    class TSessionResult: TMoveOnly {
    public:
        enum ESpecialKind {
            None = 0,
            Support = 1,
            Stress = 2
        };

        using TUidUserPair = std::pair<TString, TSessionUserPtr>;

        const TString& StatusStr() const {
            return TSessionUtils::StatusName(Status);
        }

        const TString& SpecialKindName() const {
            switch (SpecialKind) {
                case None:
                    return NONE;
                case Support:
                    return SUPPORT;
                case Stress:
                    return STRESS;
            };
        }

        std::optional<TSessionidProcessor::ESessionStatus> Status;
        TString Comment;
        long int Age = -1;
        long int Expires = 0;
        TString Ttl;
        std::unique_ptr<TAuthIdChunk> AuthId;
        std::unique_ptr<TNewSessionChunk> NewSession;
        std::unique_ptr<TResignedCookiesChunk> ResignedCookies;
        std::unique_ptr<TSessguardChunk> NewSessguards;
        ESpecialKind SpecialKind = None;
        unsigned DefaultId = 0;
        bool AllowMoreUsers = true;
        bool IsMultisession = false;
        TString ConnectionId;
        TString LoginId;

        std::vector<TUidUserPair> Users;

        TString UserTicket;

    private:
        static inline const TString NONE;
        static inline const TString SUPPORT = "SUPPORT";
        static inline const TString STRESS = "STRESS";
    };
}
