#pragma once

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>

#include <memory>

namespace NPassport::NBb {
    class TTrackResult: TMoveOnly {
    public:
        TTrackResult(const TString& uid, const TString& trackId)
            : Uid(uid)
            , TrackId(trackId)
        {
        }

        TString Uid;
        TString TrackId;
        TString Created;
        TString Expired;
        TString Content;

        std::unique_ptr<rapidjson::Document> ContentRapidObj;
    };
}
