#pragma once

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/system/types.h>

namespace NPassport::NBb {
    class TTypedValueResult: TMoveOnly {
    public:
        TTypedValueResult(const TString& name, const TString& value)
            : Name(name)
            , Value(value)
            , Type(STRING)
        {
        }

        TTypedValueResult(const TString& name, i32 value)
            : Name(name)
            , Value(IntToString<10>(value))
            , Type(NUMBER)
        {
        }

        TTypedValueResult(const TString& name, bool value)
            : Name(name)
            , Value(value ? "1" : "0")
            , Type(BOOL)
        {
        }

        enum EType {
            BOOL,
            NUMBER,
            STRING
        };

        const TString Name;
        const TString Value;
        const EType Type;
    };
}
