#pragma once

#include "base_result.h"

#include <util/generic/noncopyable.h>
#include <util/generic/string.h>
#include <util/system/types.h>

#include <memory>
#include <vector>

namespace NPassport::NBb {
    class TUserInfoResult: public TBaseResult {
    public:
        std::unique_ptr<bool> PinStatus;
    };
    using TUserInfoResultPtr = std::unique_ptr<TUserInfoResult>;

    class TBulkUserInfoResult: TMoveOnly {
    public:
        std::vector<std::pair<TString, TUserInfoResultPtr>> Results;
    };
}
