#pragma once

#include <passport/infra/libs/cpp/unistat/time_stat.h>

#include <library/cpp/http/simple/http_client.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/datetime/base.h>
#include <util/generic/fwd.h>

namespace NPassport::NBb {
    class IStaffClient {
    public:
        struct TResponse {
            bool Success = true;
            ui32 Retries = 0;
            TString Body;
        };

        virtual ~IStaffClient() = default;
        virtual TResponse GetRobotsPage(ui64 lastEntityId, NUnistat::TTimeStat& unistatResponseTime) = 0;
    };

    class TStaffClient: public IStaffClient {
    public:
        struct TSettings {
            TString Host;
            ui16 Port = 443;
            TDuration ConnectionTimeout = TDuration::MilliSeconds(5000);
            TDuration QueryTimeout = TDuration::MilliSeconds(5000);
            ui32 Retries = 3;
            ui32 Limit = 50;

            std::shared_ptr<NTvmAuth::TTvmClient> TvmClient;
        };

        TStaffClient(const TSettings& settings);
        ~TStaffClient() override = default;

        TResponse GetRobotsPage(ui64 lastEntityId, NUnistat::TTimeStat& unistatResponseTime) override;

    protected:
        TString MakeRobotsRequest(ui64 lastEntityId) const;

    private:
        const TSettings& Settings_;

        TKeepAliveHttpClient HTTPClient_;
    };
}
