#pragma once

#include "staff_client.h"

#include <passport/infra/libs/cpp/juggler/status.h>
#include <passport/infra/libs/cpp/unistat/diff.h>
#include <passport/infra/libs/cpp/unistat/time_stat.h>
#include <passport/infra/libs/cpp/utils/shared_state.h>

#include <contrib/libs/rapidjson/include/rapidjson/document.h>

#include <util/datetime/base.h>
#include <util/generic/fwd.h>

#include <unordered_set>

namespace NPassport::NBb {
    class TStaffFetcher {
    public:
        struct TSettings {
            TString CachePath;
            TDuration UpdatePeriod = TDuration::Seconds(3600);
            TStaffClient::TSettings ClientSettings;
        };

        using TRobotsList = std::unordered_set<ui64>;

        TStaffFetcher(TSettings&& settings);
        virtual ~TStaffFetcher();

        void AddUnistat(NUnistat::TBuilder& builder);
        NJuggler::TStatus GetJugglerStatus() const;

        std::shared_ptr<TRobotsList> GetRobots() const;

    protected:
        void Run();

    protected: // for tests
        virtual std::unique_ptr<IStaffClient> GetStaffClient();

    private:
        void ReadFromDisk();
        void UpdateFromStaff();

        static ui64 ParseRobotsPage(rapidjson::Value& page, TRobotsList& cache);

        void WriteCache(const std::vector<TString>& pages, TInstant timestamp = TInstant::Now()) const;

    protected: // for tests
        TInstant LastUpdateTime_;

    private:
        TSettings Settings_;

        NUtils::TSharedState<TRobotsList> RobotsList_;

        NUnistat::TSignalDiff<> UnistatQueryErrors_ = {"staff.errors.query"};
        NUnistat::TSignalDiff<> UnistatParsingErrors_ = {"staff.errors.parsing"};
        NUnistat::TTimeStat UnistatResponseTime_;
    };
}
