#include "staff_info.h"

#include <passport/infra/libs/cpp/utils/regular_task.h>

namespace NPassport::NBb {
    TStaffInfo::TStaffInfo(TStaffFetcher::TSettings&& fetcherSettings)
        : StaffFetcher_(NUtils::TRegularTaskDecorator<TStaffFetcher>::CreateUnique(
              {
                  .Period = fetcherSettings.UpdatePeriod / 12,
                  .Name = "staff_fetcher",
              },
              std::move(fetcherSettings)))
    {
    }

    TStaffInfo::~TStaffInfo() = default;

    void TStaffInfo::AddUnistat(NUnistat::TBuilder& builder) {
        StaffFetcher_->AddUnistat(builder);
    }

    NJuggler::TStatus TStaffInfo::GetJugglerStatus() const {
        return StaffFetcher_->GetJugglerStatus();
    }

    bool TStaffInfo::IsRobot(ui64 uid) const {
        return StaffFetcher_->GetRobots()->contains(uid);
    }
}
