#pragma once

#include "staff_fetcher.h"

#include <passport/infra/libs/cpp/juggler/status.h>

namespace NPassport::NBb {
    class IStaffInfo {
    public:
        virtual ~IStaffInfo() = default;

        virtual bool IsRobot(ui64 uid) const = 0;
    };

    class TStaffInfo: public IStaffInfo {
    public:
        TStaffInfo(TStaffFetcher::TSettings&& fetcherSettings);
        ~TStaffInfo() override;

        void AddUnistat(NUnistat::TBuilder& builder);
        NJuggler::TStatus GetJugglerStatus() const;

        bool IsRobot(ui64 uid) const override;

    private:
        std::unique_ptr<TStaffFetcher> StaffFetcher_;
    };
}
