#pragma once

#include <passport/infra/libs/cpp/auth_core/keymap.h>

#include <util/generic/string.h>
#include <util/system/types.h>

#include <map>

namespace NPassport::NBb {
    class TTotpProfile;

    class TTotpEncryptor {
    public:
        TTotpEncryptor(NAuth::TKeyMap&& aesKeys, NAuth::TKeyMap&& macKeys);

        TTotpProfile Decrypt(ui64 uid, const TString& value) const;
        TString Encrypt(ui64 uid, const TString& secret) const; // old versions (1 or 2)
        TString Encrypt(const TTotpProfile& profile) const;

    private:
        bool DecryptToBlock(TString& block, int& ver, const TString& value, ui64 uid) const;
        static TTotpProfile ParseBlockV12(ui64 uid, TString& block);
        static TTotpProfile ParseBlockV3(ui64 uid, const TString& block);

        TString EncryptBlock(ui32 version, const TString& plaintext) const;
        static TString PrepareBlockV12(ui64 uid, const TString& secret);
        static TString PrepareBlockV3(const TTotpProfile& profile);

        using TSecretAndPin = std::pair<TString, TString>;
        static TSecretAndPin SplitToSecretAndPin(const TString& value);

        const NAuth::TKeyMap AesKeys_;
        const NAuth::TKeyMap MacKeys_;
    };

}
